<?php include 'koneksi.php'; ?>
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title>Data Karyawan</title>
    <script>
        function confirmDelete(id) {
            Swal.fire({
                title: 'Yakin hapus?',
                text: "Data yang dihapus tidak bisa dikembalikan!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = 'hapus-gaji.php?id=' + id;
                }
            });
        }
    </script>
    <style>
        /* (Styles sama seperti yang Anda berikan) */
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap');

        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(to right, #f4f7fc, #d0e0f7);
            margin: 0;
            padding: 0;
            color: #333;
        }

        .container {
            max-width: 960px;
            margin: 50px auto;
            padding: 20px;
        }

        h2 {
            text-align: center;
            margin-bottom: 30px;
            font-size: 28px;
            color: #5f6f94;
        }

        .card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 6px 20px rgba(95, 111, 148, 0.1);
            overflow: hidden;
        }

        .card-body {
            padding: 25px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 14px;
        }

        thead th {
            background: #5f6f94;
            color: white;
            padding: 12px;
            text-align: center;
        }

        table td,
        table th {
            padding: 12px;
            border: 1px solid #e2e8f0;
            text-align: center;
        }

        .search-bar {
            text-align: right;
            margin-bottom: 15px;
        }

        .search-bar input[type="text"] {
            padding: 8px 12px;
            border: 1px solid #c3d4eb;
            border-radius: 8px;
            width: 250px;
            font-size: 14px;
            transition: 0.3s;
            background: #ffffff;
        }

        .search-bar input[type="text"]:focus {
            border-color: #5f6f94;
            outline: none;
            box-shadow: 0 0 5px rgba(95, 111, 148, 0.3);
        }

        .btn {
            display: inline-block;
            padding: 10px 18px;
            font-size: 14px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .btn-sm {
            padding: 6px 12px;
            font-size: 13px;
        }

        .btn-success {
            background: #a4c3f2;
            color: #2c3e50;
        }

        .btn-success:hover {
            background: #8fb6ee;
        }

        .btn-primary {
            background: #7b9acc;
            color: white;
        }

        .btn-primary:hover {
            background: #6786bb;
        }

        .btn-danger {
            background: #d86f7d;
            color: white;
        }

        .btn-danger:hover {
            background: #c25b69;
        }

        .btn-secondary {
            background: #ccd9f0;
            color: #2f3c55;
        }

        .btn-secondary:hover {
            background: #b6c9e8;
        }

        .modal {
            display: none;
            position: fixed;
            z-index: 9999;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background: rgba(128, 128, 128, 0.4);
            overflow-y: auto;
            padding: 40px 20px;
            animation: fadeIn 0.3s ease;
        }

        .modal-dialog {
            max-width: 500px;
            margin: auto;
        }

        .modal-content {
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
            animation: slideDown 0.3s ease;
            overflow: hidden;
        }

        .modal-header {
            background: #d0e0f7;
            color: #2f3c55;
            font-weight: 600;
            padding: 16px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .modal-body {
            padding: 20px;
            background: #f4f7fc;
        }

        .modal-footer {
            background: #e6eefb;
            padding: 16px 20px;
            display: flex;
            justify-content: flex-end;
            gap: 10px;
        }

        input[type="text"],
        input[type="number"],
        input.currency {
            width: 100%;
            padding: 10px 14px;
            margin-bottom: 15px;
            border: 1px solid #c3d4eb;
            border-radius: 8px;
            font-size: 14px;
            box-sizing: border-box;
            transition: all 0.3s ease;
            background: #fff;
        }

        input:focus {
            border-color: #7b9acc;
            outline: none;
            box-shadow: 0 0 4px rgba(123, 154, 204, 0.4);
        }

        input.currency {
            font-family: 'Poppins', monospace;
        }

        input[name="cari"] {
            margin-bottom: 0;
        }

        .btn-close {
            border: none;
            background: none;
            font-size: 20px;
            cursor: pointer;
            color: #2f3c55;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }

        @keyframes slideDown {
            from {
                transform: translateY(-30px);
                opacity: 0;
            }

            to {
                transform: translateY(0);
                opacity: 1;
            }
        }

        .top-bar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            gap: 10px;
            flex-wrap: wrap;
        }

        .search-bar {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .currency-format::before {
            content: "Rp ";
        }

        .main-navbar {
            position: sticky;
            top: 0;
            z-index: 1000;
            background: rgba(17, 100, 102, 0.9);
            backdrop-filter: blur(12px);
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.2);
        }

        .nav-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 15px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .brand {
            font-size: 22px;
            font-weight: 700;
            color: #FFCB9A;
            text-shadow: 1px 1px 3px rgba(0, 0, 0, 0.3);
        }

        .nav-links {
            list-style: none;
            display: flex;
            gap: 25px;
        }

        .nav-links li {
            display: inline-block;
        }

        .nav-link {
            color: #D1E8E2;
            text-decoration: none;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            transition: all 0.3s ease;
            padding: 10px 18px;
            border-radius: 25px;
        }

        .nav-link:hover {
            background: linear-gradient(45deg, #FFCB9A, #D9B08C);
            color: #2C3531;
            box-shadow: 0 6px 15px rgba(255, 203, 154, 0.3);
        }

        .nav-link.active {
            background: linear-gradient(45deg, #D1E8E2, #116466);
            color: white;
            box-shadow: 0 6px 20px rgba(17, 100, 102, 0.3);
        }

        @media (max-width: 768px) {
            .nav-links {
                flex-direction: column;
                background: rgba(17, 100, 102, 0.95);
                position: absolute;
                top: 70px;
                right: 0;
                width: 200px;
                padding: 15px;
                border-radius: 15px;
                display: none;
            }

            .nav-links.show {
                display: flex;
            }
        }
    </style>
    <!-- SweetAlert2 CDN -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

</head>
<!-- Navbar -->
<nav class="main-navbar">
    <div class="nav-container">
        <div class="brand">Manajemen Karyawan</div>
        <ul class="nav-links">
            <li><a href="dashboard.php" class="nav-link">Dashboard</a></li>
            <li><a href="index.php" class="nav-link active">Data Karyawan</a></li>
            <li><a href="bonuscrud/indexbonus.php" class="nav-link">Data Bonus</a></li>
        </ul>
    </div>
</nav>

<body>

    <script>
        // Format input gaji pokok ke format mata uang IDR
        const formatRupiah = new Intl.NumberFormat('id-ID', {
            style: 'currency',
            currency: 'IDR',
            minimumFractionDigits: 0,
            maximumFractionDigits: 0
        });

        function handleCurrencyInput(input) {
            let angka = input.value.replace(/[^0-9]/g, '');
            if (angka === '') {
                input.value = '';
                return;
            }
            input.value = formatRupiah.format(angka);
        }

        document.addEventListener('DOMContentLoaded', () => {
            const currencyInputs = document.querySelectorAll('input.currency');

            currencyInputs.forEach(input => {
                input.addEventListener('input', () => handleCurrencyInput(input));
                handleCurrencyInput(input);
            });
        });

        function stripCurrency(input) {
            return input.replace(/[^0-9]/g, '');
        }

        document.querySelectorAll('form').forEach(form => {
            form.addEventListener('submit', function () {
                const currencyInputs = form.querySelectorAll('input.currency');
                currencyInputs.forEach(input => {
                    input.value = stripCurrency(input.value);
                });
            });
        });
    </script>


    <div class="container">
        <h2>Data Karyawan</h2>

        <div class="top-bar">
            <button class="btn btn-success" onclick="openModal('modalTambah')">+ Tambah Data</button>

            <div class="search-bar">
                <input type="text" id="searchInput" placeholder="Cari karyawan...">
            </div>


        </div>


        <div class="card">
            <div class="card-body">
                <table>
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>NIK</th>
                            <th>Nama</th>
                            <th>Gaji Pokok</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        if (isset($_GET['cari']) && $_GET['cari'] !== '') {
                            $cari = $koneksi->real_escape_string($_GET['cari']);
                            $sql = "SELECT * FROM gaji WHERE nik LIKE '%$cari%' OR nama LIKE '%$cari%'";
                        } else {
                            $sql = "SELECT * FROM gaji";
                        }

                        $result = $koneksi->query($sql);
                        $id = 1;
                        if ($result->num_rows > 0) {
                            while ($row = $result->fetch_assoc()) {
                                echo "<tr>
                                    <td>" . $id . "</td>
                                    <td>" . $row['nik'] . "</td>
                                    <td>" . $row['nama'] . "</td>
                                    <td class= currency-format>" . number_format($row['gaji_pokok'], 0, ',', '.') . "</td>
                                    <td>
                                        <button class='btn btn-sm btn-primary' onclick='setEdit(" . $row['id'] . ",\"" . $row['nik'] . "\",\"" . $row['nama'] . "\"," . $row['gaji_pokok'] . ")'>Edit</button>
                                        <button class='btn btn-sm btn-danger' onclick=\"confirmDelete('" . $row['id'] . "')\">Hapus</button>
                                        <button class='btn btn-sm btn-secondary' onclick='showDetail(\"" . $row['nik'] . "\", \"" . $row['nama'] . "\", \"" . number_format($row['gaji_pokok'], 0, ',', '.') . "\")'>Detail</button>
                                    </td>
                                </tr>";
                                $id++;
                            }
                        } else {
                            echo "<tr><td colspan='5'>Data tidak ditemukan.</td></tr>";
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Modal Tambah -->
    <div class="modal" id="modalTambah">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST" action="">
                    <div class="modal-header">
                        <span>Tambah Data Karyawan</span>
                        <button type="button" class="btn-close" onclick="closeModal('modalTambah')">&times;</button>
                    </div>
                    <div class="modal-body">
                        <input type="text" name="nik" placeholder="NIK (16 digit)" required minlength="16"
                            maxlength="16" oninput="this.value = this.value.replace(/\D/g, '')" />

                        <input type="text" name="nama" placeholder="Nama" required />

                        <input type="text" name="gaji_pokok" placeholder="Gaji Pokok" class="currency" required />
                    </div>
                    <div class="modal-footer">
                        <button type="submit" name="simpan" class="btn btn-success">Simpan</button>
                        <button type="button" class="btn btn-secondary"
                            onclick="closeModal('modalTambah')">Batal</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Edit -->
    <div class="modal" id="modalEdit">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST" action="">
                    <input type="hidden" name="id" id="editId" />
                    <div class="modal-header">
                        <span>Edit Data Karyawan</span>
                        <button type="button" class="btn-close" onclick="closeModal('modalEdit')">&times;</button>
                    </div>
                    <div class="modal-body">
                        <input type="text" name="nik" id="editNik" placeholder="NIK (16 digit)" required minlength="16"
                            maxlength="16" oninput="this.value = this.value.replace(/\D/g, '')" />
                        <input type="text" name="nama" id="editNama" placeholder="Nama" required />
                        <input type="text" name="gaji_pokok" id="editGaji" placeholder="Gaji Pokok" class="currency"
                            required />
                    </div>
                    <div class="modal-footer">
                        <button type="submit" name="update" class="btn btn-primary">Update</button>
                        <button type="button" class="btn btn-secondary" onclick="closeModal('modalEdit')">Batal</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Detail -->
    <div class="modal" id="modalDetail">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <span>Detail Data Karyawan</span>
                    <button type="button" class="btn-close" onclick="closeModal('modalDetail')">&times;</button>
                </div>
                <div class="modal-body" id="detailBody">
                    <!-- Isi detail nanti di sini -->
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" onclick="closeModal('modalDetail')">Tutup</button>
                </div>
            </div>
        </div>
    </div>

    <script>
        function openModal(id) {
            document.getElementById(id).style.display = 'block';
        }

        function closeModal(id) {
            document.getElementById(id).style.display = 'none';
        }

        function setEdit(id, nik, nama, gaji) {
            openModal('modalEdit');
            document.getElementById('editId').value = id;
            document.getElementById('editNik').value = nik;
            document.getElementById('editNama').value = nama;
            document.getElementById('editGaji').value = new Intl.NumberFormat('id-ID', {
                style: 'currency',
                currency: 'IDR',
                minimumFractionDigits: 0,
                maximumFractionDigits: 0
            }).format(gaji);
        }

        function showDetail(nik, nama, gaji) {
            openModal('modalDetail');
            const detailHtml = `
                <p><strong>NIK:</strong> ${nik}</p>
                <p><strong>Nama:</strong> ${nama}</p>
                <p><strong>Gaji Pokok:</strong> Rp ${gaji}</p>
            `;
            document.getElementById('detailBody').innerHTML = detailHtml;
        }
    </script>

    <?php
    // --- PROSES SIMPAN ---
    if (isset($_POST['simpan'])) {
        $nik = $_POST['nik'];
        $nama = $_POST['nama'];
        $gaji = preg_replace('/[^0-9]/', '', $_POST['gaji_pokok']);

        // Cek apakah NIK sudah ada
        $cekNik = $koneksi->prepare("SELECT id FROM gaji WHERE nik = ?");
        $cekNik->bind_param("s", $nik);
        $cekNik->execute();
        $cekNik->store_result();

        if ($cekNik->num_rows > 0) {
            echo "<script>
            Swal.fire({
                icon: 'error',
                title: 'Gagal',
                text: 'NIK sudah terdaftar!'
            });
            </script>";
        } else {
            $stmt = $koneksi->prepare("INSERT INTO gaji (nik, nama, gaji_pokok) VALUES (?, ?, ?)");
            $stmt->bind_param("ssi", $nik, $nama, $gaji);

            if ($stmt->execute()) {
                echo "<script>
                Swal.fire({
                    icon: 'success',
                    title: 'Berhasil',
                    text: 'Data berhasil ditambahkan!',
                    timer: 2000,
                    showConfirmButton: false
                }).then(() => {
                    window.location.href = '" . $_SERVER['PHP_SELF'] . "';
                });
                </script>";
            } else {
                echo "<script>
                Swal.fire({
                    icon: 'error',
                    title: 'Gagal',
                    text: 'Gagal menambahkan data!'
                });
                </script>";
            }
            $stmt->close();
        }
        $cekNik->close();
    }

    // --- PROSES UPDATE ---
    if (isset($_POST['update'])) {
        $id = $_POST['id'];
        $nik = $_POST['nik'];
        $nama = $_POST['nama'];
        $gaji_pokok_string = $_POST['gaji_pokok'];
        $gaji_clean = preg_replace("/[^\d]/", "", $gaji_pokok_string);
        $gaji = (int) $gaji_clean;

        // Cek apakah NIK sudah ada di data lain selain id ini
        $cekNik = $koneksi->prepare("SELECT id FROM gaji WHERE nik = ? AND id != ?");
        $cekNik->bind_param("si", $nik, $id);
        $cekNik->execute();
        $cekNik->store_result();

        if ($cekNik->num_rows > 0) {
            echo "<script>
            Swal.fire({
                icon: 'error',
                title: 'Gagal',
                text: 'NIK sudah terdaftar di data lain!'
            });
            </script>";
        } else {
            $stmt = $koneksi->prepare("UPDATE gaji SET nik=?, nama=?, gaji_pokok=? WHERE id=?");
            $stmt->bind_param("isii", $nik, $nama, $gaji, $id);

            if ($stmt->execute()) {
                echo "<script>
                Swal.fire({
                    icon: 'success',
                    title: 'Berhasil',
                    text: 'Data berhasil diupdate!',
                    timer: 2000,
                    showConfirmButton: false
                }).then(() => {
                    window.location.href = '" . $_SERVER['PHP_SELF'] . "';
                });
                </script>";
            } else {
                echo "<script>
                Swal.fire({
                    icon: 'error',
                    title: 'Gagal',
                    text: 'Gagal mengupdate data!'
                });
                </script>";
            }
            $stmt->close();
        }
        $cekNik->close();
    }
    ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const searchInput = document.getElementById('searchInput');
            const tableRows = document.querySelectorAll('tbody tr');

            searchInput.addEventListener('input', function () {
                const query = searchInput.value.toLowerCase();

                tableRows.forEach(row => {
                    const nik = row.cells[1]?.textContent.toLowerCase() || '';
                    const nama = row.cells[2]?.textContent.toLowerCase() || '';
                    const gaji = row.cells[3]?.textContent.toLowerCase() || '';

                    const matches = nik.includes(query) || nama.includes(query) || gaji.includes(query);
                    row.style.display = matches ? '' : 'none';
                });
            });
        });
    </script>


</body>

</html>