<?php include 'koneksi.php'; ?>
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title>Dashboard Manajemen Karyawan</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap');

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #2C3531 0%, #116466 50%, #D1E8E2 100%);
            min-height: 100vh;
            color: #2C3531;
        }

        .container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 30px;
        }

        .header {
            text-align: center;
            margin-bottom: 40px;
        }

        .header h1 {
            font-size: 42px;
            color: #FFCB9A;
            text-shadow: 3px 3px 6px rgba(44, 53, 49, 0.4);
            margin-bottom: 15px;
            font-weight: 700;
        }

        .header p {
            color: #D1E8E2;
            font-size: 18px;
            font-weight: 300;
        }

        .nav-bar {
            background: rgba(17, 100, 102, 0.9);
            border-radius: 20px;
            padding: 25px;
            margin-bottom: 40px;
            backdrop-filter: blur(15px);
            box-shadow: 0 10px 40px rgba(17, 100, 102, 0.3);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .nav-links {
            display: flex;
            justify-content: center;
            gap: 25px;
            flex-wrap: wrap;
        }

        .nav-link {
            background: linear-gradient(45deg, #FFCB9A, #D9B08C);
            color: #2C3531;
            padding: 15px 30px;
            border-radius: 30px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.4s ease;
            box-shadow: 0 6px 20px rgba(255, 203, 154, 0.3);
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .nav-link:hover {
            transform: translateY(-3px) scale(1.05);
            box-shadow: 0 10px 30px rgba(255, 203, 154, 0.5);
            background: linear-gradient(45deg, #D9B08C, #FFCB9A);
        }

        .nav-link.active {
            background: linear-gradient(45deg, #D1E8E2, #116466);
            color: white;
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 25px;
            margin-bottom: 40px;
        }

        .stat-card {
            background: linear-gradient(135deg, rgba(255, 255, 255, 0.95), rgba(209, 232, 226, 0.95));
            padding: 35px 25px;
            border-radius: 20px;
            text-align: center;
            box-shadow: 0 10px 30px rgba(17, 100, 102, 0.2);
            border: 2px solid rgba(255, 203, 154, 0.3);
            transition: all 0.4s ease;
            position: relative;
            overflow: hidden;
        }

        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 4px;
            background: linear-gradient(90deg, #FFCB9A, #D9B08C);
        }

        .stat-card:hover {
            transform: translateY(-8px) scale(1.03);
            box-shadow: 0 20px 50px rgba(17, 100, 102, 0.3);
        }

        .stat-icon {
            font-size: 48px;
            margin-bottom: 15px;
            opacity: 0.8;
        }

        .stat-value {
            font-size: 42px;
            font-weight: 700;
            color: #2C3531;
            margin-bottom: 10px;
            text-shadow: 1px 1px 3px rgba(0, 0, 0, 0.1);
        }

        .stat-label {
            color: #116466;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            font-size: 14px;
        }

        .charts-section {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(500px, 1fr));
            gap: 30px;
            margin-bottom: 40px;
        }

        .chart-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 20px;
            padding: 30px;
            box-shadow: 0 10px 40px rgba(17, 100, 102, 0.2);
            border: 1px solid rgba(255, 203, 154, 0.3);
            transition: all 0.3s ease;
        }

        .chart-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 50px rgba(17, 100, 102, 0.3);
        }

        .chart-title {
            font-size: 20px;
            font-weight: 600;
            color: #2C3531;
            margin-bottom: 20px;
            text-align: center;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .recent-activity {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 20px;
            padding: 30px;
            box-shadow: 0 10px 40px rgba(17, 100, 102, 0.2);
            border: 1px solid rgba(255, 203, 154, 0.3);
        }

        .activity-title {
            font-size: 24px;
            font-weight: 600;
            color: #2C3531;
            margin-bottom: 25px;
            text-align: center;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .activity-item {
            display: flex;
            align-items: center;
            padding: 15px;
            margin-bottom: 15px;
            background: linear-gradient(45deg, rgba(255, 203, 154, 0.1), rgba(209, 232, 226, 0.1));
            border-radius: 15px;
            border-left: 4px solid #116466;
            transition: all 0.3s ease;
        }

        .activity-item:hover {
            transform: translateX(10px);
            box-shadow: 0 5px 20px rgba(17, 100, 102, 0.2);
        }

        .activity-icon {
            width: 50px;
            height: 50px;
            background: linear-gradient(45deg, #116466, #2C3531);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 15px;
            color: #FFCB9A;
            font-weight: bold;
        }

        .activity-content {
            flex: 1;
        }

        .activity-text {
            font-weight: 500;
            color: #2C3531;
            margin-bottom: 5px;
        }

        .activity-time {
            color: #116466;
            font-size: 12px;
            opacity: 0.8;
        }

        .quick-actions {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-top: 30px;
        }

        .action-card {
            background: linear-gradient(135deg, #116466, #2C3531);
            color: white;
            padding: 25px;
            border-radius: 15px;
            text-align: center;
            text-decoration: none;
            transition: all 0.3s ease;
            box-shadow: 0 8px 25px rgba(17, 100, 102, 0.3);
        }

        .action-card:hover {
            transform: translateY(-5px) scale(1.05);
            box-shadow: 0 12px 35px rgba(17, 100, 102, 0.4);
            color: white;
        }

        .action-icon {
            font-size: 36px;
            margin-bottom: 15px;
            color: #FFCB9A;
        }

        .action-title {
            font-weight: 600;
            font-size: 16px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        @media (max-width: 768px) {
            .container {
                padding: 20px;
            }

            .header h1 {
                font-size: 32px;
            }

            .stats-grid {
                grid-template-columns: 1fr;
            }

            .charts-section {
                grid-template-columns: 1fr;
            }
        }
    </style>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
</head>


<body>
    <div class="container">
        <div class="header">
            <h1>Dashboard Manajemen Karyawan</h1>
            <p>Sistem Informasi Pengelolaan Data Karyawan dan Bonus</p>
        </div>

        <div class="nav-bar">
            <div class="nav-links">
                <a href="index.php" class="nav-link">Data Karyawan</a>
                <a href="indexbonus.php" class="nav-link">Data Bonus</a>
                <a href="bonuscrud/indexbonus.php" class="nav-link">Data Gaji</a>
            </div>
        </div>

        <?php
        // Statistik Data
        $totalKaryawan = $koneksi->query("SELECT COUNT(*) as total FROM gaji")->fetch_assoc()['total'] ?? 0;
        $totalGajiPokok = $koneksi->query("SELECT SUM(gaji_pokok) as total FROM gaji")->fetch_assoc()['total'] ?? 0;
        $totalBonus = $koneksi->query("SELECT SUM(bonus) as total FROM bonus")->fetch_assoc()['total'] ?? 0;
        $avgGaji = $totalKaryawan > 0 ? $totalGajiPokok / $totalKaryawan : 0;
        ?>

        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-icon">👥</div>
                <div class="stat-value"><?= number_format($totalKaryawan) ?></div>
                <div class="stat-label">Total Karyawan</div>
            </div>
            <div class="stat-card">
                <div class="stat-icon">💰</div>
                <div class="stat-value">Rp <?= number_format($totalGajiPokok, 0, ',', '.') ?></div>
                <div class="stat-label">Total Gaji Pokok</div>
            </div>
            <div class="stat-card">
                <div class="stat-icon">📊</div>
                <div class="stat-value">Rp <?= number_format($avgGaji, 0, ',', '.') ?></div>
                <div class="stat-label">Rata-rata Gaji</div>
            </div>
        </div>


        
    </div>

    <script>
        // Chart untuk Distribusi Gaji
        const salaryCtx = document.getElementById('salaryChart').getContext('2d');

        <?php
        // Data untuk chart gaji
        $salaryRanges = $koneksi->query("
            SELECT 
                CASE 
                    WHEN gaji_pokok < 3000000 THEN 'Di bawah 3 Juta'
                    WHEN gaji_pokok BETWEEN 3000000 AND 5000000 THEN '3 - 5 Juta'
                    WHEN gaji_pokok BETWEEN 5000001 AND 8000000 THEN '5 - 8 Juta'
                    ELSE 'Di atas 8 Juta'
                END as range_gaji,
                COUNT(*) as jumlah
            FROM gaji 
            GROUP BY range_gaji
        ");

        $salaryLabels = [];
        $salaryData = [];
        while ($range = $salaryRanges->fetch_assoc()) {
            $salaryLabels[] = $range['range_gaji'];
            $salaryData[] = $range['jumlah'];
        }
        ?>

        const salaryChart = new Chart(salaryCtx, {
            type: 'doughnut',
            data: {
                labels: <?= json_encode($salaryLabels) ?>,
                datasets: [{
                    data: <?= json_encode($salaryData) ?>,
                    backgroundColor: [
                        '#FFCB9A',
                        '#D9B08C',
                        '#116466',
                        '#2C3531'
                    ],
                    borderWidth: 3,
                    borderColor: '#fff'
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        position: 'bottom',
                    }
                }
            }
        });

        // Chart untuk Bonus Bulanan
        const bonusCtx = document.getElementById('bonusChart').getContext('2d');

        <?php
        // Data untuk chart bonus 6 bulan terakhir
        $bonusMonthly = $koneksi->query("
            SELECT 
                DATE_FORMAT(tanggal, '%Y-%m') as bulan,
                SUM(jumlah_bonus) as total_bonus
            FROM bonus 
            WHERE tanggal >= DATE_SUB(CURDATE(), INTERVAL 6 MONTH)
            GROUP BY DATE_FORMAT(tanggal, '%Y-%m')
            ORDER BY bulan ASC
        ");

        $bonusLabels = [];
        $bonusData = [];
        while ($month = $bonusMonthly->fetch_assoc()) {
            $bonusLabels[] = date('M Y', strtotime($month['bulan'] . '-01'));
            $bonusData[] = $month['total_bonus'];
        }
        ?>

        const bonusChart = new Chart(bonusCtx, {
            type: 'line',
            data: {
                labels: <?= json_encode($bonusLabels) ?>,
                datasets: [{
                    label: 'Total Bonus',
                    data: <?= json_encode($bonusData) ?>,
                    backgroundColor: 'rgba(17, 100, 102, 0.1)',
                    borderColor: '#116466',
                    borderWidth: 3,
                    fill: true,
                    tension: 0.4
                }]
            },
            options: {
                responsive: true,
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            callback: function (value, index, values) {
                                return 'Rp ' + value.toLocaleString('id-ID');
                            }
                        }
                    }
                },
                plugins: {
                    legend: {
                        display: false
                    }
                }
            }
        });
    </script>
</body>

</html>